## Read in the data ##

data<-read.csv(file.choose())

## Install needed packages for weighted tables ##

install.packages("weights")
install.packages("pollster")
library(weights)
library(pollster)

## Get some basic info on data ##

topline(df=data, variable=gender2, weight=raked1)

## Difference-in-means testing ##

wtd.t.test(data$income, data$gender2, weight=data$raked1)

## Pearson's correlation ##

wtd.cor(data$income, data$age, weight=data$raked1)

## Cross-tabulation ##

wtd.chi.sq(data$senate, data$race, weight=data$raked1)

