## Read in the data ##

data<-read.csv(file.choose())

## Install needed packages for weighted tables ##

install.packages("survey")
install.packages("questionr")
install.packages("Hmisc")
install.packages("weights")
install.packages("pollster")
library(survey)
library(questionr)
library(Hmisc)
library(weights)
library(pollster)

## Gather summary statistics ##

table(data$senate)  #unweighted frequence
wtd.table(x=data$senate, w=data$raked1)  #weighted frequency
wpct(x=data$senate, w=data$raked1)  #weighted proportion

table(data$potus)
wtd.table(x=data$potus, w=data$raked1)
wpct(x=data$potus, w=data$raked1)

table(data$potus_approval)
wtd.table(x=data$potus_approval, w=data$raked1)
wpct(x=data$potus_approval, w=data$raked1)

mean(data$age, na.rm=TRUE)
weighted.mean(data$age, data$raked1, na.rm=TRUE)

table(data$age_cat)
wtd.table(x=data$age_cat, w=data$raked1)
wpct(x=data$age_cat, w=data$raked1)

table(x=data$gender2)
wtd.table(x=data$gender2, w=data$raked1)
wpct(x=data$gender2, w=data$raked1)

table(x=data$income)
wtd.table(x=data$income, w=data$raked1)
wpct(x=data$income, w=data$raked1)

table(x=data$education)
wtd.table(x=data$education, w=data$raked1)
wpct(x=data$education, w=data$raked1)

table(x=data$race)
wtd.table(x=data$race, w=data$raked1)
wpct(x=data$race, w=data$raked1)

table(x=data$ideology)
wtd.table(x=data$ideology, w=data$raked1)
wpct(x=data$ideology, w=data$raked1)

table(x=data$religion)
wtd.table(x=data$religion, w=data$raked1)
wpct(x=data$religion, w=data$raked1)

## Get crosstabs ## 

crosstab(df=data, x=gender2, y=senate, w=raked1)
crosstab(df=data, x=age_cat, y=senate, w=raked1)
crosstab(df=data, x=race, y=senate, w=raked1)
crosstab(df=data, x=education, y=senate, w=raked1)
crosstab(df=data, x=ideology, y=senate, w=raked1)
crosstab(df=data, x=religion, y=senate, w=raked1)

crosstab(df=data, x=gender2, y=potus, w=raked1)
crosstab(df=data, x=age_cat, y=potus, w=raked1)
crosstab(df=data, x=race, y=potus, w=raked1)
crosstab(df=data, x=education, y=potus, w=raked1)
crosstab(df=data, x=ideology, y=potus, w=raked1)
crosstab(df=data, x=religion, y=potus, w=raked1)


