## Load libraries ##

library(MASS)
library(nnet)

## Generate some data with a binary DV ##

y<-rbinom(n=1000, size=1, prob=.6); head(y)
x1<-rnorm(n=1000, mean=(y*50), sd=50); head(x1)
x2<-rnorm(n=1000, mean=(y^4), sd=100); head(x2)

## Estimate a probit and logit ##

m1<-glm(y~x1+x2, family=binomial(link="logit")); summary(m1)
m2<-glm(y~x1+x2, family=binomial(link="probit")); summary(m2)

## Estimate an ordered probit ##

y2<-rpois(n=100, 2); table(y2)
x3<-rnorm(n=100, mean=(y2*.5), sd=5); head(x3)
x4<-rnorm(n=100, mean=(y^3), sd=6); head(x4)

y2.ordered<-ordered(as.factor(y2))
m2<-polr(y2.ordered~x3+x4); summary(m2)

## Multinomial logits ##

m3<-multinom(y2~x3+x4); summary(m3)

## Event counts ##

m4<-glm(y2~x3+x4, family=poisson(link=log)); summary(m3)
m5<-glm.nb(y2~x3+x4); summary(m4)