** Read the GDP data into Stata **

** Declare the data to be time-series **

tsset period

** Simple bivariate regression **

reg gdp period

** Test for heteroskedasticity and autocorrelation **

estat hettest
estat dwatson
estat bgodfrey
estat bgodfrey, lag(2)

predict res, res
reg res L(1/2).res

** Visualize the autocorreleation **

twoway scatter res period

** Compare two trending variables (Open home sales/fertility file) **

clear
twoway (line home year)
twoway (line fertil year)

reg home fertility
reg home fertility year

** Estimate an AR(1) Model with GDP Data **

clear

tsset period
reg gdp L.gdp period

** Check whether autocorrelation now modeled out of error **

estat dwatson
estat bgodfrey
estat bgodfrey, lag(2)
predict res2, res
reg res2 L.res2


** Estimate the AR(2) Model and assess autocorrelation**

reg gdp L(1/2).gdp period
estat dwatson
estat bgodfrey
estat bgodfrey, lag(2)

predict res3, res
reg res3 L.res3 L2.res3

twoway scatter res3 period

** Upload seasonal temperature data **

clear

tsset index
reg avg_temp year
estat bgodfrey

** Attempt to address correlation via lags **

reg avg_temp L.avg L2.avg year
estat bgodfrey

** Use fixed effects to address autocorrelation **

gen season=.
replace season=1 if month==12 | month==1 | month==2
replace season=2 if month==3 | month==4 | month==5
replace season=3 if month==6 | month==7 | month==8
replace season=4 if month==9 | month==10 | month==11

reg avg_temp year i.season
estat bgodfrey
estat bgodfrey, lag(2)

** Transforming highly persistent series **

gen delta_temp=(avg_temp - L.avg_temp)/(L.avg_temp)
gen diff_temp=avg_temp-L.avg_temp

** Checking for unit roots **

dfuller avg_temp
dfuller delta_temp

** Forecasting **

forecast create, replace
tsset index
regress avg_temp i.month L.avg_temp
estimates store m1
forecast estimates m1
forecast solve, begin(1518) periods(12) /// 
simulate(errors, statistic(mean, prefix(m)) ///
statistic(stddev, prefix(sd)))
gen ui=mavg+sdavg
gen li=mavg-sdavg

twoway (line f_avg_temp index if index<=1518) ///
(rarea ui li index) (line f_avg_temp index) if year>=2019 ///
& index<=1529
