** Single dummy variable model **

reg realrinc i.female educ

** Visual depiction **

margins female, at(educ=(0(4)20))
marginsplot

** Regression with 2 dummy variables **

reg realrinc i.female i.nonwhite educ

** Visual depiction **

margins female nonwhite, at(educ=(0(4)20))
marginsplot

** Code age cohorts **

gen age1=1 if age>=18 & age<=30
replace age1=0 if age1!=1

gen age2=1 if age>30 & age<=45
replace age2=0 if age2!=1

gen age3=1 if age>45 & age<=60
replace age3=0 if age3!=1

gen age4=1 if age>60
replace age4=0 if age4!=1

sum age1 age2 age3 age4 

** Regression with dummied out age cohorts **

reg realrinc educ female nonwhite age2 age3 age4

** It doesn't matter which category we exclude. We'll get different coefficients, but that's fine **

reg realrinc educ female nonwhite age1 age3 age4

** Demonstrate that perfect multicollinearity is unallowed **

reg realrinc educ female nonwhite age1 age2 age3 age4

** Get the visual depiction **

gen age_cohort=.
replace age_co=1 if age1==1
replace age_co=2 if age2==1
replace age_co=3 if age3==1
replace age_co=4 if age4==1
tab age_cohort

reg realrinc educ female nonwhite i.age_cohort

margins age_cohort
marginsplot, recast(scatter)

** Log the DV **

gen log_inc=log(realrinc)
twoway (kdensity realrinc)
twoway (kdensity log_inc)

** Estimate OLS with logged DV **

reg log_inc female
ameans realrinc if female==1
ameans realrinc if female==0
display exp(-0.4793225)

** Two-dummy interaction effect **

reg realrinc i.female##i.nonwhite

** Get margins and plot effect **

margins female, at(nonwhite=(0,1))
marginsplot, recast(scatter)

** One-dummy, one-continuous interaction effect **

reg realrinc female i.nonwhite##c.educ

** Margins and visualize the effect **

margins nonwhite, at(educ=(0(4)20))
marginsplot

** Two-continuous interaction **

reg realrinc c.educ##c.age

** Margins and visualization **

sum educ
display 13.73-2.97
display 13.73+2.97

margins, at(age=(18(10)90) educ=(10.76 16.70))
marginsplot




