## Load libraries ##

install.packages("jtools")
library(jtools)
install.packages("sjPlot")
library(sjPlot)
install.packages("sjmisc")
library(sjmisc)
install.packages("ggplot2")
library(ggplot2)
install.packages("gridExtra")
library(gridExtra)

## Set working directory ##

setwd("C:/Users/dhughe10/Dropbox/AUM/courses/fall_2021/puad_7130/data_and_code")

## Read in the data ##

data1<-read.csv("gss18.csv")

## Single dummy variable model ##

m1<-lm(realrinc~female+educ, data=data1); summary(m1)

## Visual Depiction ## 

plot_model(m1, type = "pred", terms = c("educ", "female"))

## Regression with 2 dummies ##

m2<-lm(realrinc~female+nonwhite+educ, data=data1); summary(m2)

## Visual Depiction ## 

p1<-plot_model(m2, type = "pred", terms = c("educ", "female"))
p2<-plot_model(m2, type = "pred", terms = c("educ", "nonwhite"))

plot_grid(list(p1, p2))

## Another approach ##

summary(m2)
f1<-function(x){-11135.6 + 3106*x}
f2<-function(x){-11135.6 + 3106*x -11478.4}
f3<-function(x){-11135.6 + 3106*x -5915.0}
f4<-function(x){-11135.6 + 3106*x -11478.4 -5915}

plot(x=data1$educ, y=data1$realrinc, type='n', xlim=c(0, 20))
curve(f1, col='red', xlim=c(0, 20))
curve(f2, col='blue', add=TRUE)
curve(f3, col='purple', add=TRUE)
curve(f4, col='orange', add=TRUE)

## Code age cohorts ##

data1$age1[data1$age<=30]<-1
data1$age1[data1$age>30]<-0

data1$age2[data1$age>30 & data1$age<=45]<-1
data1$age2[data1$age<=30 | data1$age>45]<-0

data1$age3[data1$age>45 & data1$age<=60]<-1
data1$age3[data1$age<=45 | data1$age>60]<-0

data1$age4[data1$age>60]<-1
data1$age4[data1$age<=60]<-0

data1$cohort[data1$age1==1]<-1
data1$cohort[data1$age2==1]<-2
data1$cohort[data1$age3==1]<-3
data1$cohort[data1$age4==1]<-4
summary(data1$cohort)

## Regression with dummied out categories ##

data1$age_cohort<-as.factor(data1$cohort)

m3<-lm(realrinc~educ+female+nonwhite+age_cohort, data=data1); summary(m3)

p3<-plot_model(m3, type = "pred", terms = c("age_cohort")); p3

## Log the DV ##

data1$log_inc<-log(data1$realrinc)

## Regression with logged DV ##

m4<-lm(log_inc~female, data=data1); summary(m4)
exp(-0.47932)

## Two-dummy interaction ##

data1$f.female<-as.factor(data1$female)
data1$f.nonwhite<-as.factor(data1$nonwhite)

m5<-lm(realrinc~f.female*f.nonwhite, data=data1); summary(m5)

plot_model(m5, type="pred", terms=c("f.female", "f.nonwhite"))

## One-dummy, one continuous interaction ##

m6<-lm(realrinc~female+nonwhite*educ, data=data1); summary(m6)

plot_model(m6, type="pred", terms=c("educ", "nonwhite"))

## Two-continuous interaction ##

m7<-lm(realrinc~age*educ, data=data1); summary(m7)
plot_model(m7, type="int")
plot_model(m7, type="int", mdrt.values="meansd")
