** Create 1,000 blank observations **

set obs 1000

** Generate some fake data with a linear relationship ** 

gen x=_n
gen y = x + rnormal(0, 100)

** Visualize the data you just created **

twoway scatter y x || lfit y x

** Calculate Pearson's r with p-value **

pwcorr x y, sig

** Create a dichotomous variable **

gen z=runiformint(0, 1)

** Conduct a difference of means test using z & t **

ztest y, by(z) sd1(303.55) sd2(305.69)

ttest y, by(z) unequal

** Create some categorical data **

gen a = runiformint(1, 2)
gen b= a + runiformint(-1, 1)

** Get a crosstab **

tab2 a b

** Get the chi-squared test statistica and gamma coefficient *

tab2 a b, chi gamma

** Get the phi coefficient **

display sqrt(363.64/1000)

** Get Cramer's V **

tab2 a b, V
