## Generate some fake data with a linear relationship ##

x <- (1:1000)

data1<-data.frame(x)
data1$y <- NA
data1$y <- data1$x + rnorm(1000, 0, 100)

## Visualize the data you just created ##

plot(x=data1$x, y=data1$y)

## Calculate Pearson's r ##

cor(data1$x, data1$y)
cor.test(data1$x, data1$y)

## Create a dichotomous variable ##

data1$z <- NA
data1$z <- rbinom(n=1000, size=1, prob=.5)

## Conduct a difference-of-means test ##

t.test(data1$y~data1$z)

## Create some categorical data ##

data1$a <- NA
data1$a <- sample(1:3, 1000, replace=TRUE)
data1$b <- NA
data1$b <- data1$a + sample(-1:1, 1000, replace=TRUE)

## Get the crosstab ##

tab1 <- table(data1$a, data1$b); tab1
install.packages("gmodels")
library(gmodels)
CrossTable(x=data1$a, y=data1$b, prop.r=FALSE, prop.c=FALSE,
	 prop.t=FALSE, prop.chisq=FALSE, chisq=TRUE)
install.packages("vcd")
library(vcd)
install.packages("vcdExtra")
library(vcdExtra)
assocstats(tab1)
GKgamma(tab1)