** Set the working directory **

cd "C:\Users\dhughe10\Dropbox\AUM\courses\fall_2021\puad_7130\data_and_code"

** Read in the GSS data **

use "unit3_data.dta"

** Get summaries of data **

sum age years_of_educ occupational_prestige
proportion female
sum age, detail

** Get the density curve of a variable **

kdensity age

** Clean it up a bit **

 kdensity age, ytitle(Density) xtitle(Age) ///
 title("") legend(off)
 
 ** Change the scheme (https://www.stata.com/manuals13/g-4schemesintro.pdf) **
 
 set scheme s2mono
 kdensity age
 
 set scheme economist
 kdensity age
 
ssc install blindschemes, replace

set scheme plotplain
kdensity age

set scheme plottig
kdensity age

set scheme s2color
kdensity age

** Get a boxplot **

graph box age

** Now a boxplot by group **

graph box age, over(female)

** Get a histogram **

hist age
hist age, bin(15) 
hist age, discrete fraction

** Make a bar graph **

graph bar (count), over(atheist)
graph hbar (count), over(atheist)
graph bar (mean) age, over(sexuality)

** Make a pie chart **

graph pie, over(sexuality)
graph pie, over(ideology) pie(1, explode) ///
 pie(2, explode) pie(3, explode) plabel(1 percent) ///
 plabel(2 percent) plabel(3 percent)
 
** Make a scatterplot **

twoway scatter occupation years_of_edu
twoway (scatter occupation years_of) || lfit ///
	occupation years_of
	
** Combine two plots into one figure **

graph box age, over(female) nodraw
graph save "figa.gph"
graph twoway scatter occupation years_of_edu, nodraw
graph save "figb.gph"

graph combine "figa.gph" "figb.gph"

** Create a lattice **

twoway (scatter occupation years_of), by(female)
